#include "config.h"
 

/***********************************************************
**   Function : fun_eeprom_Write
**   INPUT    : lu8v_addr;lu8v_data
**   OUTPUT   : none
**   NOTE     : none
***********************************************************/

void fun_eeprom_Write(u8 lu8v_addr, u8 lu8v_data)
{

	_eea = lu8v_addr;
	_eed = lu8v_data;

	#if(mac_eeprom_type == mac_eeprom_Short)

	_bp     = 1;
	_mp1    = 0x40;
	_iar1  |= 0x08;
	_iar1  |= 0x04;
	while(_iar1 & 0x04);
	_iar1	&=	0xf7;				//disable WREN	
	_bp     = 0;	

	#endif	
//============================================================	
	#if(mac_eeprom_type == mac_eeprom_Long)

	_mp1l = 0x40;
	_mp1h = 1;
	_iar1	|=	0x8;				//enable WREN
	_iar1	|=	0x4;				//active write 
	while(_iar1 & 0x04);		//wait write end
	_iar1	&=	0xf7;				//disable WREN	

	#endif
}


/***********************************************************
**   Function : fun_eeprom_Read
**   INPUT    : lu8v_addr
**   OUTPUT   : lu8v_eeprom_byte
**   NOTE     : none
***********************************************************/

u8 fun_eeprom_Read(u8 lu8v_addr)
{
	u8 lu8v_eeprom_byte;
		
	_eea = lu8v_addr;


	#if(mac_eeprom_type == mac_eeprom_Short)

	_bp     = 1;
	_mp1    = 0x40;
	_iar1  |= 0x02;
	_iar1  |= 0x01;
		
	while(_iar1 & 0x01);
	lu8v_eeprom_byte = _eed;		
	_iar1  &= 0xfd;  
	
	#endif
//============================================================	
	#if(mac_eeprom_type == mac_eeprom_Long)

	_mp1l = 0x40;
	_mp1h = 1;
	_iar1 |=0x2;				//enable RDEN
	_iar1 |=0x1;				//active READ 
	while(_iar1 & 0x01);		//wait read end
	lu8v_eeprom_byte = _eed;
	_iar1 &=	0xfD;				//disable RDEN	

	#endif

	return lu8v_eeprom_byte;	

}


//------------------------------------------------ END ----------------------------------------------------//